/*
 * Decompiled with CFR 0.152.
 */
package net.jayjay.dangerzone.container;

import net.jayjay.dangerzone.container.ContainerBase;
import net.jayjay.dangerzone.container.ItemStack;

public class ContainerInventory
extends ContainerBase {
    public ItemStack[] inventory;
    public int selectedSlot = 0;
    private static final int MAX_STACK_SIZE = 65535;

    public ContainerInventory(int size) {
        super(size);
        this.inventory = new ItemStack[size];
    }

    public boolean addItem(int id, int count, boolean isBlock) {
        int i2 = 0;
        while (i2 < this.inventory.length) {
            ItemStack stack = this.inventory[i2];
            if (stack != null && stack.id == id && stack.isBlock == isBlock && stack.count < 65535) {
                int space = 65535 - stack.count;
                int toAdd = Math.min(space, count);
                stack.addCount(toAdd);
                if ((count -= toAdd) <= 0) {
                    return true;
                }
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < this.inventory.length) {
            if (this.inventory[i2] == null || this.inventory[i2].isEmpty()) {
                int toAdd = Math.min(65535, count);
                this.inventory[i2] = new ItemStack(id, toAdd, isBlock);
                if ((count -= toAdd) <= 0) {
                    return true;
                }
            }
            ++i2;
        }
        return count <= 0;
    }

    public ItemStack removeItem(int slot, int count) {
        if (slot < 0 || slot >= this.inventory.length) {
            return null;
        }
        ItemStack stack = this.inventory[slot];
        if (stack == null || stack.isEmpty()) {
            return null;
        }
        int removed = Math.min(count, stack.count);
        stack.count -= removed;
        ItemStack result = new ItemStack(stack.id, removed, stack.isBlock);
        if (stack.isEmpty()) {
            this.inventory[slot] = null;
        }
        return result;
    }

    public ItemStack getSelectedItem() {
        if (this.selectedSlot < 0 || this.selectedSlot >= this.inventory.length) {
            return null;
        }
        return this.inventory[this.selectedSlot];
    }

    public void swapSlots(int slot1, int slot2) {
        if (slot1 < 0 || slot1 >= this.inventory.length) {
            return;
        }
        if (slot2 < 0 || slot2 >= this.inventory.length) {
            return;
        }
        ItemStack temp = this.inventory[slot1];
        this.inventory[slot1] = this.inventory[slot2];
        this.inventory[slot2] = temp;
    }

    public void selectSlot(int slot) {
        if (slot >= 0 && slot < 9) {
            this.selectedSlot = slot;
        }
    }
}

